<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Billitems extends Eloquent {

	protected $table = 'billitems';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'quantity', 'price', 'total_price', 'bill_id', 'user_id');

	public function product()
	{
		return $this->belongsTo('Products', 'product_id');
	}

	public function bill()
	{
		return $this->belongsTo('Bills', 'bill_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}