<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bills extends Eloquent {

	protected $table = 'bills';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('amount', 'branch_id', 'invoice_number', 'vendor_id', 'user_id');

	public function branch()
	{
		return $this->belongsTo('Branches', 'branch_id');
	}

	public function vendor()
	{
		return $this->belongsTo('Vendors', 'vendor_id');
	}

	public function items()
	{
		return $this->hasMany('Billitems', 'bill_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}