<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Expenses extends Eloquent {

	protected $table = 'expenses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('account_id', 'amount', 'date', 'note', 'type', 'expense_item', 'user_id');

	public function account()
	{
		return $this->belongsTo('Accounts', 'account_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}