<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoiceitems extends Eloquent {

	protected $table = 'invoiceitems';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('invoice_id', 'product_id', 'quantity', 'price', 'total_price', 'user_id');

	public function invoice()
	{
		return $this->belongsTo('Invoices', 'invoice_id');
	}

	public function product()
	{
		return $this->belongsTo('Products', 'product_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}