<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Stores extends Eloquent {

	protected $table = 'stores';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'branch_id', 'user_id');

	public function branch()
	{
		return $this->belongsTo('Branches', 'branch_id');
	}

	public function products()
	{
		return $this->hasMany('Products', 'store_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}