<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Expenses extends Model 
{

    protected $table = 'expenses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('account_id', 'amount', 'date', 'note', 'type', 'expense_item', 'user_id');

    public function account()
    {
        return $this->belongsTo('Accounts', 'account_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}