<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Products extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'store_id', 'buy_price', 'sell_price', 'code', 'user_id', 'quantity');

    public function store()
    {
        return $this->belongsTo('Stores', 'store_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}