<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Accounts extends Model 
{

    protected $table = 'accounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'open_balance', 'balance', 'user_id');

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}