<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Clients extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'address', 'g_name', 'g_phone', 'g_address', 'code', 'phone', 'user_id');

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}