<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vendorpayments extends Model 
{

    protected $table = 'vendorpayments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('amount', 'note', 'vendor_id', 'user_id');

    public function vendor()
    {
        return $this->belongsTo('Vendors', 'vendor_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}