<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Installmentinvoices extends Model 
{

    protected $table = 'installmentinvoices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('client_id', 'branch_id', 'sell_price', 'base_price', 'pre_amount', 'remain_amount', 'start_at', 'count', 'amount', 'system', 'paid', 'note', 'user_id');

    public function client()
    {
        return $this->belongsTo('Clients', 'client_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branches', 'branch_id');
    }

    public function items()
    {
        return $this->hasMany('Installmentitems', 'installment_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}