<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnedItemsTable extends Migration {

	public function up()
	{
		Schema::create('returned_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('returned_id')->nullable();
			$table->integer('product_id')->nullable();
			$table->double('price')->nullable();
			$table->integer('quantity')->nullable();
			$table->double('total')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('returned_items');
	}
}