<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->string('id', 32)->default('NA');
			$table->string('serial_no', 8)->unique()->default('NA');
			$table->string('firstname', 128)->default('NA');
			$table->string('lastname', 128)->default('NA');
			$table->string('email_id', 256)->default('NA');
			$table->string('mobile', 15)->default('0');
			$table->string('personal_address', 2048)->default('NA');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}