<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupsTable extends Migration {

	public function up()
	{
		Schema::create('groups', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('owner_user_id')->unsigned()->nullable();
			$table->bigInteger('owner_student_id')->unsigned()->nullable();
			$table->string('name', 128);
			$table->string('description', 1024);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('groups');
	}
}