<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventRealizationsTable extends Migration {

	public function up()
	{
		Schema::create('event_realizations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('event_facts_id')->unsigned();
			$table->datetime('date_from');
			$table->datetime('date_to');
			$table->string('realization_comment', 2048);
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('public')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('event_realizations');
	}
}