<?php

namespace App\Models\Activities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Activity extends Eloquent {

	protected $table = 'activities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getInstitution()
	{
		return $this->belongsTo('App\Models\Orgs\Institution');
	}

	public function getUser()
	{
		return $this->belongsTo('App\Models\Orgs\User');
	}

	public function getChallengeElements()
	{
		return $this->hasMany('App\Models\Challenges\ChallengeElement');
	}

	public function getAttendances()
	{
		return $this->hasMany('App\Models\Students\Attandance');
	}

	public function getKeywords()
	{
		return $this->belongsToMany('App\Models\Keywords\Keyword', 'activity_keyword')->withPivot('credits');
	}

	public function getEpisodeType()
	{
		return $this->belongsTo('App\Models\Involvements\EpisodeType');
	}

	public function getInvolvement()
	{
		return $this->belongsTo('Involvement');
	}

}