<?php

namespace App\Models\Students;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attandance extends Eloquent {

	protected $table = 'attendances';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('state', 'max_creadits');

	public function getActionFacts()
	{
		return $this->belongsTo('App\Models\Events\EventFacts');
	}

	public function getStudent()
	{
		return $this->belongsTo('App\Models\Students\Student');
	}

	public function getActionRealization()
	{
		return $this->belongsTo('App\Models\Events\EventRealization');
	}

	public function getChallenge()
	{
		return $this->belongsTo('App\Models\Challenges\Challenge');
	}

	public function getQuiz()
	{
		return $this->belongsTo('App\Models\Quizes\Quiz');
	}

	public function getKeywords()
	{
		return $this->belongsToMany('App\Models\Keywords\Keyword', 'att_keyword', 'attendance_id', 'keyword_id');
	}

	public function getActivity()
	{
		return $this->belongsTo('App\Models\Activities\Activity');
	}

}