<?php

namespace App\Models\Challenges;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Challenge extends Eloquent {

	protected $table = 'challenges';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getInstitution()
	{
		return $this->belongsTo('App\Models\Orgs\Institution');
	}

	public function getUser()
	{
		return $this->belongsTo('App\Models\Orgs\User');
	}

	public function getElements()
	{
		return $this->hasMany('App\Models\Challenges\ChallengeElement');
	}

	public function getLevelLimits()
	{
		return $this->hasMany('App\Models\Challenges\ChallengeLevel');
	}

	public function getAccreditation()
	{
		return $this->hasOne('App\Models\Accreditation\Accreditation');
	}

	public function getKeywords()
	{
		return $this->belongsToMany('App\Models\Keywords\Keyword', 'challenge_keywords')->withPivot('credits');
	}

	public function getAttendances()
	{
		return $this->hasMany('App\Models\Students\Attandance');
	}

	public function getEpisodeType()
	{
		return $this->belongsTo('App\Models\Involvements\EpisodeType');
	}

	public function getInvolvements()
	{
		return $this->belongsToMany('App\Models\Involvements\Involvement', 'challenge_involvement')->withPivot('credits_value','preparation_hours','involvement_qr');
	}

}