<?php

namespace App\Models\Events;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EventFacts extends Eloquent {

	protected $table = 'event_facts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('age0', 'public_registration');

	public function getRealizations()
	{
		return $this->hasMany('App\Models\Events\EventRealization');
	}

	public function getInstitution()
	{
		return $this->belongsTo('App\Models\Orgs\Institution');
	}

	public function getUser()
	{
		return $this->belongsTo('App\Models\Orgs\User');
	}

	public function getAccreditation()
	{
		return $this->hasOne('App\Models\Accreditation\Accreditation');
	}

	public function getScopeRating()
	{
		return $this->belongsTo('App\Models\Accreditation\ScopeRating');
	}

	public function getKeywords()
	{
		return $this->belongsToMany('App\Models\Keywords\Keyword', 'action_facts_keyword')->withPivot('credits');
	}

	public function getEpisodeType()
	{
		return $this->belongsTo('App\Models\Involvements\EpisodeType');
	}

	public function getInvolvements()
	{
		return $this->belongsToMany('App\Models\Involvements\Involvement', 'event_facts_involvement')->withPivot('credits_value','preparation_hours','involvement_qr');
	}

	public function getQuiz()
	{
		return $this->hasOne('EventFacts');
	}

}