<?php

namespace App\Models\Orgs;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Institution extends Eloquent {

	protected $table = 'institutions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lat', 'lng');

	public function getActionFacts()
	{
		return $this->hasMany('App\Models\Events\EventFacts');
	}

	public function getChallenges()
	{
		return $this->hasMany('App\Models\Challenges\Challenge');
	}

	public function addQuizes()
	{
		return $this->hasMany('App\Models\Quizes\Quiz');
	}

	public function getCategory()
	{
		return $this->belongsTo('App\Models\Orgs\InstCategory');
	}

	public function getResponsible()
	{
		return $this->belongsTo('App\Models\Orgs\User', 'responsible_id');
	}

	public function getActivities()
	{
		return $this->hasMany('App\Models\Activities\Activity');
	}

	public function getUsers()
	{
		return $this->hasMany('App\Models\Orgs\User');
	}

}