<?php

namespace App\Models\Involvements;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Involvement extends Eloquent {

	protected $table = 'involvements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getEpisodeTypes()
	{
		return $this->belongsToMany('App\Models\Involvements\EpisodeType', 'episode_type_involvement');
	}

	public function getEventFacts()
	{
		return $this->belongsToMany('App\Models\Events\EventFacts', 'event_facts_involvement')->withPivot('credits_value','preparation_hours','involvement_qr');
	}

	public function getChallenges()
	{
		return $this->belongsToMany('App\Models\Challenges\Challenge', 'challenge_involvement')->withPivot('credits_value','preparation_hours','involvement_qr');
	}

	public function getQuizes()
	{
		return $this->hasMany('App\Models\Quizes\Quiz');
	}

	public function getActivities()
	{
		return $this->hasMany('App\Models\Activities\Activity');
	}

}