<?php

namespace App\Models\Keywords;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Keyword extends Eloquent {

	protected $table = 'keywords';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getQuizes()
	{
		return $this->belongsToMany('App\Models\Quizes\Quiz', 'quiz_keyword')->withPivot('credits');
	}

	public function getChallenges()
	{
		return $this->belongsToMany('App\Models\Challenges\Challenge', 'challenge_keywords')->withPivot('credits');
	}

	public function getEventFacts()
	{
		return $this->belongsToMany('App\Models\Events\EventFacts', 'event_facts_keyword')->withPivot('credits');
	}

	public function getActivities()
	{
		return $this->belongsToMany('App\Models\Activities\Activity', 'activity_keyword')->withPivot('credits');
	}

}