<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccreditationsTable extends Migration {

	public function up()
	{
		Schema::create('accreditations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('concept');
			$table->integer('request')->default('0');
			$table->integer('rating')->default('0');
			$table->integer('count')->default('0');
			$table->integer('proposal');
			$table->boolean('decision_approved');
			$table->integer('rating_scope')->nullable();
			$table->integer('rating_excellence')->nullable();
			$table->integer('rating_equality')->nullable();
			$table->integer('rating_stem')->nullable();
			$table->integer('rating_prestige')->nullable();
			$table->integer('s1')->nullable();
			$table->integer('s2')->nullable();
			$table->integer('s3')->nullable();
			$table->integer('s4')->nullable();
			$table->integer('s5')->nullable();
			$table->integer('s6')->nullable();
			$table->integer('s7')->nullable();
			$table->integer('s8')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('accreditations');
	}
}