<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstitutionsTable extends Migration {

	public function up()
	{
		Schema::create('institutions', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('inst_category_id')->unsigned()->nullable();
			$table->bigInteger('responsible_id')->unsigned()->nullable();
			$table->string('name', 128);
			$table->string('description', 1024);
			$table->string('street', 128);
			$table->string('city', 128);
			$table->string('zip', 8);
			$table->string('phone', 16);
			$table->string('logo', 256);
			$table->string('photo', 256);
			$table->string('web', 128);
			$table->timestamps();
			$table->softDeletes();
			$table->float('lat')->nullable();
			$table->float('lng')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('institutions');
	}
}