<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('Products', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('OwnProduction', 'food', 'nonFood', 'gastro'));
			$table->timestamps();
			$table->integer('priceCategoryId');
			$table->string('name');
			$table->string('generatedName');
			$table->string('variantName')->nullable();
			$table->string('barCode');
			$table->string('companyId');
			$table->enum('paymentMethod', array('bankTransfer', 'cash', 'consignment', 'advancePayment'));
			$table->integer('categoryId');
			$table->integer('subCategoryId')->nullable();
			$table->enum('state', array('active', 'discontinued'));
			$table->json('priceCalculation')->nullable();
			$table->enum('vatKey', array('27', '18', '5', '0'));
			$table->string('unit');
			$table->float('purchasePrice');
			$table->enum('currency', array('HUF'));
			$table->string('transferPrice');
			$table->boolean('shopCanManage')->default(false);
			$table->json('ntakDetails')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Products');
	}
}