<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStockTable extends Migration {

	public function up()
	{
		Schema::create('Stock', function(Blueprint $table) {
			$table->increments('id');
			$table->string('barCode')->index();
			$table->string('wareHouseId');
			$table->timestamps();
			$table->string('productId');
			$table->float('price');
			$table->float('transferPrice');
			$table->integer('shopId')->nullable();
			$table->enum('vatKey', array('27', '18', '5', '0'));
			$table->enum('type', array('OwnProduction', 'food', 'nonFood', 'gastro'));
		});
	}

	public function down()
	{
		Schema::drop('Stock');
	}
}