<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsultationLogsTable extends Migration {

	public function up()
	{
		Schema::create('consultation_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('doctor_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->datetime('date');
			$table->string('case_id', 250);
			$table->string('duration', 250);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('consultation_logs');
	}
}