<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLabTestUserTable extends Migration {

	public function up()
	{
		Schema::create('lab_test_user', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('lab_sub_id')->unsigned();
			$table->integer('doctor_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->integer('case_id')->unsigned();
			$table->string('frequency', 250)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('lab_test_user');
	}
}