<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserAllegriesTable extends Migration {

	public function up()
	{
		Schema::create('user_allegries', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('allegries_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->integer('doctor_id')->unsigned();
			$table->boolean('still_has');
			$table->integer('status')->default('0');
			$table->string('other_allegries', 250)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_allegries');
	}
}