<?php

namespace App\Models;

class Course extends Eloquent {

	protected $table = 'courses';
	public $timestamps = true;

	public function user()
	{
		return $this->hasMany('Course');
	}

	public function session()
	{
		return $this->belongsTo('Course');
	}

	public function properties()
	{
		return $this->belongsTo('Course');
	}

	public function tools()
	{
		return $this->belongsTo('Course');
	}

	public function attachments()
	{
		return $this->morphMany('Attachment');
	}

}