<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('ar_name', 255);
			$table->string('en_name', 255);
			$table->string('image', 255);
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
			$table->softDeletes();
			$table->string('profit_ratio', 255)->default('0');
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}