<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id');
			$table->integer('subcategory_id');
			$table->integer('seller_id');
			$table->string('ar_name', 255);
			$table->string('en_name', 255);
			$table->longText('ar_details');
			$table->longText('en_details');
			$table->string('image', 255);
			$table->tinyInteger('active')->default('1');
			$table->tinyInteger('status')->default('1');
			$table->string('reason_refused', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}