<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function attributes()
	{
		return $this->hasMany('ProductsAttribute');
	}

	public function images()
	{
		return $this->hasMany('ProductsImages');
	}

	public function favourits()
	{
		return $this->hasMany('Favourite');
	}

}