<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('is_financial_param', 'name', 'recommendations');

	public function companies()
	{
		return $this->belongsToMany('Company');
	}

	public function programs()
	{
		return $this->belongsToMany('Program');
	}

	public function templates()
	{
		return $this->hasMany('Template');
	}

}