<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyServicesTable extends Migration {

	public function up()
	{
		Schema::create('company_services', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->tinyInteger('is_active');
			$table->timestamp('activated_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('company_services');
	}
}