<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgramServiceTable extends Migration {

	public function up()
	{
		Schema::create('program_service', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('program_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->tinyInteger('is_active')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('program_service');
	}
}