<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Program extends Eloquent {

	protected $table = 'programs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('year', 'name', 'max_perc_co_financing', 'date_of_announcement', 'submission_deadline', 'is_state_aid', 'is_min_aid', 'max_bfp_sum');

	public function companies()
	{
		return $this->belongsToMany('Company');
	}

	public function services()
	{
		return $this->belongsToMany('Service');
	}

}