<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Page extends Model 
{

    protected $table = 'pages';
    public $timestamps = true;

    public function author()
    {
        return $this->belongsTo('App\User');
    }

    public function children()
    {
        return $this->hasMany('App\Page');
    }

    public function parent()
    {
        return $this->belongsTo('App\Page', 'parent_id');
    }

    public function categories()
    {
        return $this->belongsToMany('App\Category');
    }

    public function translations()
    {
        return $this->hasMany('App\Translation');
    }

}