<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->unsigned();
			$table->enum('status', array('visible', 'hidden', 'archived'));
			$table->smallInteger('menu_order')->unsigned()->default('0');
			$table->timestamp('published_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}