<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('institution_id')->unsigned()->nullable();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('accreditation_id')->unsigned()->nullable();
			$table->bigInteger('scope_rating_id')->unsigned()->nullable();
			$table->bigInteger('episode_type_id')->unsigned()->nullable();
			$table->bigInteger('quiz_id')->unsigned()->nullable();
			$table->boolean('quiz_public');
			$table->string('name', 256);
			$table->string('description', 2048);
			$table->boolean('age0');
			$table->boolean('age1');
			$table->boolean('age2');
			$table->boolean('age3');
			$table->string('price', 512);
			$table->string('web', 512);
			$table->string('internal_text', 1024);
			$table->integer('attend_hours');
			$table->boolean('immediate_attendance');
			$table->double('lat');
			$table->double('lng');
			$table->integer('capacity');
			$table->boolean('accreditation_approved');
			$table->integer('s1');
			$table->integer('s2');
			$table->integer('s3');
			$table->integer('s4');
			$table->integer('s5');
			$table->integer('s6');
			$table->integer('s7');
			$table->integer('s8');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('public_registration')->default(false);
			$table->string('address');
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}