<?php

namespace App\Models\Challenges;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Challenge extends Eloquent {

	protected $table = 'challenges';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getInstitution()
	{
		return $this->belongsTo('Institution');
	}

	public function getUser()
	{
		return $this->belongsTo('User');
	}

	public function getElements()
	{
		return $this->hasMany('ChallengeElement');
	}

	public function getLevelLimits()
	{
		return $this->hasMany('ChallengeLevel');
	}

	public function getAccreditation()
	{
		return $this->hasOne('Accreditation');
	}

	public function getKeywords()
	{
		return $this->belongsToMany('Keyword', 'challenge_keywords');
	}

	public function getAttendances()
	{
		return $this->hasMany('Attendance');
	}

	public function getEpisodeType()
	{
		return $this->belongsTo('EpisodeType');
	}

	public function getInvolvements()
	{
		return $this->belongsToMany('InvolvementTypes', 'challenge_involvement');
	}

}