<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Team extends Model 
{

    protected $table = 'teams';
    public $timestamps = true;

    public function people()
    {
        return $this->belongsToMany('Person')->withPivot('is_project_manager');
    }

    public function skills()
    {
        return $this->hasManyThrough('Skill', 'Person');
    }

}