<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonsTable extends Migration {

	public function up()
	{
		Schema::create('persons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('started_at')->nullable();
			$table->string('name', 255)->nullable();
			$table->string('avatar', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->longText('bio')->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('social_link', 255)->nullable();
			$table->string('slug', 255);
		});
	}

	public function down()
	{
		Schema::drop('persons');
	}
}