<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nick')->nullable();
			$table->string('pass')->nullable();
			$table->string('name')->nullable();
			$table->string('patronymic')->nullable();
			$table->string('surname')->nullable();
			$table->string('patname')->nullable();
			$table->string('fullname');
			$table->string('avatar')->nullable();
			$table->string('cover')->nullable();
			$table->string('background')->nullable();
			$table->text('about');
			$table->enum('gender', array('m', 'f'));
			$table->datetimeTz('birthday');
			$table->ipAddress('ip_address');
			$table->enum('verified', array('0', '1'));
			$table->timestamp('verified_at')->nullable();
			$table->timestamp('lastseen_at')->nullable();
			$table->string('lang', 3)->default('ru');
			$table->json('pro')->nullable();
			$table->enum('notification', array('0', '1'))->nullable();
			$table->enum('active', array('0', '1'))->nullable();
			$table->json('banned')->nullable();
			$table->string('timezone')->nullable();
			$table->string('ref_code')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}