<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('ref_code');

	public function phones()
	{
		return $this->hasMany('Phone', 'id');
	}

	public function emails()
	{
		return $this->hasMany('Email', 'id');
	}

	public function socials()
	{
		return $this->hasOne('Social', 'id');
	}

	public function referres()
	{
		return $this->hasOne('Referrer');
	}

	public function devices()
	{
		return $this->hasOne('Devices');
	}

}