<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Nutritionist extends Model 
{

    protected $table = 'nutritionist';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->hasOne('USERS', 'user_id');
    }

    public function notes()
    {
        return $this->hasMany('Notes', 'nutritionist_id');
    }

    public function dreamplans()
    {
        return $this->hasMany('Dreamplans', 'nutritionist_id');
    }

    public function members()
    {
        return $this->hasMany('Membernutritionist', 'nutritionist_id');
    }

}