<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Nutritionist extends Eloquent {

	protected $table = 'nutritionist';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->hasOne('USERS', 'user_id');
	}

	public function notes()
	{
		return $this->hasMany('Notes', 'nutritionist_id');
	}

	public function dreamplans()
	{
		return $this->hasMany('Dreamplans', 'nutritionist_id');
	}

	public function members()
	{
		return $this->hasMany('Membernutritionist', 'nutritionist_id');
	}

}