<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Member extends Model 
{

    protected $table = 'member';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->hasOne('USERS', 'user_id');
    }

    public function nutritionist()
    {
        return $this->hasOne('Membernutritionist', 'nutritionist_id');
    }

    public function subscription()
    {
        return $this->hasMany('Subscription', 'user_id');
    }

    public function subscriptionhistory()
    {
        return $this->hasMany('Subscriptionhistory', 'member_id');
    }

}