<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePermissionsTable extends Migration {

	public function up()
	{
		Schema::create('permissions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 250);
			$table->string('display_name', 250);
			$table->integer('system');
			$table->tinyInteger('sort');
		});
	}

	public function down()
	{
		Schema::drop('permissions');
	}
}