<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->string('company', 50);
			$table->string('address', 100);
			$table->string('address2', 100);
			$table->string('city', 50);
			$table->string('postal_code', 20);
			$table->string('country', 50);
			$table->string('phone_work', 20);
			$table->string('phone_home', 20);
			$table->string('mail', 100);
			$table->boolean('newsletter');
			$table->boolean('yacht_owner');
			$table->enum('type', array('agency', 'customer', 'broker'));
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}